<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);



// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
    // Acceder a los valores individuales de los datos combinados
    $cCodProd = $data['CodProd'];
    $cNombre = $data['Nombre'];
    $cCodBar = $data['CodBar'];
    $cCodSunat = $data['CodSunat'];
    $cCodExt = $data['CodExt'];
    $cAfectoIGV = $data['AfectoIGV'];
    $cPorcentajeIGV = $data['PorcentajeIGV'];
    $cPeso = $data['Peso'];
    $cStockMinimo = $data['StockMinimo'];
    $cPCompraAnt = $data['PCompraAnt'];
    $cFCompraAnt = $data['FCompraAnt'];
    $cDocCompraAnt = $data['DocCompraAnt'];
    $cUltPCompra = $data['UltPCompra'];
    $cUltFCompra = $data['UltFCompra'];
    $cUltDocCompra = $data['UltDocCompra'];
    $cUnidadId = $data['UnidadId'];
    $cCapacidad = $data['Capacidad'];
    $cFraccionId = $data['FraccionId'];
    $cImporteICBP = $data['ImporteICBP'];
    $cDescripcion = $data['Descripcion'];
    $cActivo = $data['Activo'];
    $cContenido = $data['Contenido'];
    $cInformacion = $data['Informacion'];
    $cPathFoto = $data['PathFoto'];
    $cCategoriaId = $data['CategoriaId'];
    $cMarcaId = $data['MarcaId'];
    $cModeloId = $data['ModeloId'];
    $cPPrecio_Menor = $data['PPrecio_Menor'];
    $cPPrecio_Mayor = $data['PPrecio_Mayor'];
    $cPPrecio_Dist = $data['PPrecio_Dist'];
    $cPrecMenor_und = $data['PrecMenor_und'];
    $cPrecmenor_Fra = $data['Precmenor_Fra'];
    $cPrecmayor_Und = $data['Precmayor_Und'];
    $cPrecmayor_Fra = $data['Precmayor_Fra'];
    $cPrecdist_Und = $data['Precdist_Und'];
    $cPrecdist_Fra = $data['Precdist_Fra'];
    $cEmpresaId = $data['EmpresaId'];
    $cSucursalId = $data['SucursalId'];
    $nIdProd = $data['nIdProd'];
    $cEstado = $data['Estado'];

    if ($cEstado == 'NUEVO') {

        // Ejemplo de inserción en la tabla productos
        $queryProducto = "INSERT INTO productos(codigo_producto, nombre, codigo_barras, codigo_sunat, codigo_externo, afecto_igv, porcentaje_igv, peso, 
            stock_minimo, pcompra_ant, fcompra_ant, doccompra_ant, ult_pcompra, ult_fcompra, ult_doccompra, unidad_id, capacidad, fraccion_id,
            importe_icbp, pprecio_menor, pprecio_mayor, pprecio_dist, precmenor_und, precmenor_fra, precmayor_und, precmayor_fra, precdist_und, precdist_fra,
            descripcion, activo, contenido, informacion, path_foto, categoria_id, marca_id, modelo_id, empresa_id)
        VALUES('$cCodProd', '$cNombre', '$cCodBar', '$cCodSunat', '$cCodExt', '$cAfectoIGV', '$cPorcentajeIGV', '$cPeso', '$cStockMinimo', '$cPCompraAnt', '$cFCompraAnt', 
            '$cDocCompraAnt', '$cUltPCompra', '$cUltFCompra', '$cUltDocCompra', '$cUnidadId', '$cCapacidad', '$cFraccionId', '$cImporteICBP', 
            '$cPPrecio_Menor', '$cPPrecio_Mayor', '$cPPrecio_Dist', '$cPrecMenor_und', '$cPrecmenor_Fra', '$cPrecmayor_Und', '$cPrecmayor_Fra', '$cPrecdist_Und', '$cPrecdist_Fra',
            '$cDescripcion', '$cActivo', '$cContenido', '$cInformacion', '$cPathFoto', '$cCategoriaId', '$cMarcaId', '$cModeloId', '$cEmpresaId')";

        $resultadoProducto = mysqli_query($conn, $queryProducto);
        if (!$resultadoProducto) {
            throw new Exception(mysqli_error($conn));
        }

        // Obtener el ID del último registro insertado
        $IdProd = mysqli_insert_id($conn);
        
        // Ejemplo de inserción en la tabla equivalencia
        foreach ($data['equivalencias'] as $equivalencias_) {
            $cnombre = $equivalencias_['nombre'];
            $cCapacidad = $equivalencias_['capacidad_precio'];
            $cAbrev = $equivalencias_['abrev_precio'];
            $cAbrev_Universal = $equivalencias_['abrev_universal'];
            $cPrecio_Venta = $equivalencias_['precio_venta'];

            $queryEquivalencia = "INSERT INTO equivalencias(producto_id, nombre, capacidad_precio, abrev_precio, abrev_universal, precio_venta, 
                empresa_id, sucursal_id)
            VALUES('$IdProd', '$cnombre', '$cCapacidad', '$cAbrev', '$cAbrev_Universal', '$cPrecio_Venta', '$cEmpresaId', '$cSucursalId')";
            
            $resultadoEquivalencia = mysqli_query($conn, $queryEquivalencia);
            if (!$resultadoEquivalencia) {
                throw new Exception(mysqli_error($conn));
            }
        }

    } elseif ($cEstado == 'MODIFICAR') { 
        $queryUpd_Equivalencia = "UPDATE equivalencias SET IUD = 'D' WHERE producto_id = $nIdProd";
        $resultadoUpd_Equivalencia = mysqli_query($conn, $queryUpd_Equivalencia);        
        if (!$resultadoUpd_Equivalencia) {
            throw new Exception(mysqli_error($conn));
        }
        
        $queryUpd_Producto = "UPDATE productos SET codigo_producto = '$cCodProd', nombre = '$cNombre', codigo_barras = '$cCodBar', codigo_sunat = '$cCodSunat', 
            codigo_externo = '$cCodExt', afecto_igv = '$cAfectoIGV', porcentaje_igv = '$cPorcentajeIGV', peso = '$cPeso', stock_minimo = '$cStockMinimo',
            pcompra_ant = '$cPCompraAnt', fcompra_ant = '$cFCompraAnt', doccompra_ant = '$cDocCompraAnt', ult_pcompra = '$cUltPCompra', 
            ult_fcompra = '$cUltFCompra', ult_doccompra = '$cUltDocCompra', unidad_id = '$cUnidadId', capacidad = '$cCapacidad', fraccion_id = '$cFraccionId',
            importe_icbp = '$cImporteICBP', pprecio_menor = '$cPPrecio_Menor', pprecio_mayor = '$cPPrecio_Mayor', pprecio_dist = '$cPPrecio_Dist', 
            precmenor_und = '$cPrecMenor_und', precmenor_fra = '$cPrecmenor_Fra', precmayor_und = '$cPrecmayor_Und', precmayor_fra = '$cPrecmayor_Fra', 
            precdist_und = '$cPrecdist_Und', precdist_fra = '$cPrecdist_Fra', descripcion = '$cDescripcion', activo = '$cActivo', contenido = '$cContenido',
            informacion = '$cInformacion', path_foto = '$cPathFoto', categoria_id = '$cCategoriaId', marca_id = '$cMarcaId', modelo_id = '$cModeloId', empresa_id = '$cEmpresaId'
        WHERE id = $nIdProd";
        
        $resultadoUpd_Producto = mysqli_query($conn, $queryUpd_Producto);        
        if (!$resultadoUpd_Producto) {
            throw new Exception(mysqli_error($conn));
        }

        // Ejemplo de inserción en la tabla equivalencia
        foreach ($data['equivalencias'] as $equivalencias_) {
            $cnombre = $equivalencias_['nombre'];
            $cCapacidad = $equivalencias_['capacidad_precio'];
            $cAbrev = $equivalencias_['abrev_precio'];
            $cAbrev_Universal = $equivalencias_['abrev_universal'];
            $cPrecio_Venta = $equivalencias_['precio_venta'];

            $queryEquivalencia = "INSERT INTO equivalencias(producto_id, nombre, capacidad_precio, abrev_precio, abrev_universal, precio_venta, 
                empresa_id, sucursal_id)
            VALUES('$nIdProd', '$cnombre', '$cCapacidad', '$cAbrev', '$cAbrev_Universal', '$cPrecio_Venta', '$cEmpresaId', '$cSucursalId')";
            
            $resultadoEquivalencia = mysqli_query($conn, $queryEquivalencia);
            if (!$resultadoEquivalencia) {
                throw new Exception(mysqli_error($conn));
            }
        }

        //Elimina Detalle de Venta para Evitar la Duplicidad
        $queryDel_Equivalencia = "DELETE FROM equivalencias WHERE producto_id = $nIdProd AND IUD = 'D'";
        $resultadoDel_Equivalencia = mysqli_query($conn, $queryDel_Equivalencia);        
        if (!$resultadoDel_Equivalencia) {
           throw new Exception(mysqli_error($conn));
        }

    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);

?>