<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permitir solicitudes desde cualquier origen
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Si la solicitud es de tipo OPTIONS, responde con los encabezados CORS y termina la ejecución
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("HTTP/1.1 200 OK");
    exit;
}

// Directorio base donde se encuentran los archivos
$directorioBase = dirname(__FILE__) . '/pdfs/';

// Validar si se ha enviado una petición de descarga
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del cuerpo de la solicitud POST
    $datosPost = file_get_contents("php://input");
    $datosPostArray = json_decode($datosPost, true);

    // Verificar que se hayan proporcionado los datos necesarios
    if (!empty($datosPostArray['nombre']) && !empty($datosPostArray['tipo']) && !empty($datosPostArray['ruta'])) {
        $nombreArchivo = $datosPostArray['nombre'];
        $tipoArchivo = $datosPostArray['tipo'];
        $rutaArchivo = $directorioBase . $datosPostArray['ruta'] . '/' . $nombreArchivo;

        // Validar que el archivo exista
        if (file_exists($rutaArchivo)) {
            // Establecer las cabeceras para la descarga
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="' . $nombreArchivo . '"');
            header('Content-Length: ' . filesize($rutaArchivo));

            // Enviar el archivo al cliente
            readfile($rutaArchivo);
            exit;
        } else {
            // El archivo no existe
            http_response_code(404);
            echo 'El archivo solicitado no está disponible para descarga.';
            // echo 'Archivo : ' . $nombreArchivo;
            exit;
        }
    } else {
        // Datos insuficientes proporcionados
        http_response_code(400);
        echo 'Datos insuficientes para la descarga del archivo.';
        exit;
    }
} else {
    // Método de solicitud no admitido
    http_response_code(405);
    echo 'Método de solicitud no admitido.';
    exit;
}
?>
