document.getElementById("form_busqueda").addEventListener("submit", function(event) {
    // Evitar que el formulario se envíe de forma predeterminada
    event.preventDefault();

    // Obtener el valor del RUC ingresado en el formulario
    var ruc = document.getElementById("ruc").value;

    // Crear un objeto XMLHttpRequest
    var xhr = new XMLHttpRequest();

    // Configurar la solicitud AJAX
    xhr.open("POST", "buscar_documentos.php", true);
    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

    // Manejar la respuesta de la solicitud AJAX
    xhr.onreadystatechange = function() {
        if (xhr.readyState === XMLHttpRequest.DONE) {
            if (xhr.status === 200) {
                // Convertir la respuesta JSON en un objeto JavaScript
                var response = JSON.parse(xhr.responseText);

                // Verificar si se encontraron documentos
                if (response.length > 0) {
                    // Obtener el elemento de la tabla
                    var tabla = document.getElementById("tabla_documentos");

                    // Limpiar la tabla antes de agregar nuevos datos
                    tabla.innerHTML = '';

                    // Iterar sobre los documentos y agregarlos a la tabla
                    response.forEach(function(documento) {
                        var fila = tabla.insertRow();
                        fila.insertCell().textContent = documento.nserie;
                        fila.insertCell().textContent = documento.ndocumento;
                        fila.insertCell().textContent = documento.fecha_emision;
                        fila.insertCell().textContent = documento.fecha_vencimiento;
                        fila.insertCell().textContent = documento.moneda;
                        fila.insertCell().textContent = documento.tipo_cambio;
                        fila.insertCell().textContent = documento.afecto_igv;
                        fila.insertCell().textContent = documento.porcentaje_igv;
                        fila.insertCell().textContent = documento.igv;
                        fila.insertCell().textContent = documento.afecto;
                        fila.insertCell().textContent = documento.inafecto;
                        fila.insertCell().textContent = documento.exonerado;
                        fila.insertCell().textContent = documento.total;
                        var accionesCell = fila.insertCell();
                        accionesCell.innerHTML = '<a href="descargar_pdf.php?documento_id=' + documento.id + '"><img src="pdf_icon.png" alt="Descargar PDF"></a> <a href="descargar_xml.php?documento_id=' + documento.id + '"><img src="xml_icon.png" alt="Descargar XML"></a>';
                    });
                } else {
                    // Mostrar un mensaje si no se encontraron documentos
                    alert("No se encontraron documentos para el RUC proporcionado.");
                }
            } else {
                // Mostrar un mensaje de error si la solicitud falla
                alert("Error al realizar la solicitud AJAX.");
            }
        }
    };

    // Enviar la solicitud AJAX con el parámetro RUC
    xhr.send("ruc=" + encodeURIComponent(ruc));
});

