<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consulta de Ventas</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }

        h1 {
            text-align: center;
            margin-bottom: 20px;
        }

        form {
            background-color: #fff;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        label {
            font-weight: bold;
            display: block;
            margin-bottom: 10px;
        }

        input[type="text"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }

        button[type="submit"] {
            background-color: #4CAF50;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        button[type="submit"]:hover {
            background-color: #45a049;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #f2f2f2;
        }

        tr:hover {
            background-color: #f2f2f2;
        }
    </style>
<body>

<h1>Consulta de Ventas</h1>

<!-- Formulario de filtro -->
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
    <label for="documento">Filtrar por documento de identidad o razón social:</label>
    <input type="text" id="documento" name="documento">
    <button type="submit">Filtrar</button>
</form>

<?php
error_reporting(E_ALL ^ E_NOTICE);
// Se incluye el archivo que contiene la clase generica
include_once '../conexion.php';

// Si se envió el formulario, procesar el filtro
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtener el valor del documento de identidad o razón social del formulario
    $documento = $_POST["documento"];
    
    // Consulta SQL para obtener las ventas según el filtro
    $sql = "SELECT fecha_emision, razon_social, direccion, gravado, inafecto, exonerado, igv, total FROM ventas
            WHERE documento_identidad = documento AND (docfiscal_id <> 5 AND docfiscal_id <> 6)
            ORDER BY fecha_emision, nserie, ndocumento ASC";

    // Ejecutar la consulta SQL
    $result = mysqli_query($conn, $sql);

    // Mostrar la tabla de resultados si hay ventas encontradas
    if (mysqli_num_rows($result) > 0) {
        echo "<h2>Resultados de la búsqueda:</h2>";
        echo "<table>";
        echo "<thead>";
        echo "<tr>";
        echo "<th>ID Venta</th>";
        echo "<th>Documento de Identidad</th>";
        echo "<th>Razón Social</th>";
        echo "<th>Driección</th>";
        echo "<th>Descargar PDF</th>";
        echo "<th>Descargar XML</th>";
        echo "</tr>";
        echo "</thead>";
        echo "<tbody>";

        while ($row = mysqli_fetch_assoc($result)) {
            $id_venta = $row["id_venta"];
            $documento_identidad = $row["documento_identidad"];
            $vendedor = $row["vendedor"];
            $email_cliente = $row["email"];

            echo "<tr>";
            echo "<td>$id_venta</td>";
            echo "<td>$documento_identidad</td>";
            echo "<td>$vendedor</td>";
            echo "<td>$email_cliente</td>";
            echo "<td><a href='descargar_pdf.php?id_venta=$id_venta'>Descargar PDF</a></td>";
            echo "<td><a href='descargar_xml.php?id_venta=$id_venta'>Descargar XML</a></td>";
            echo "</tr>";
        }

        echo "</tbody>";
        echo "</table>";
    } else {
        echo "<p>No se encontraron ventas para el documento de identidad o razón social proporcionado.</p>";
    }
}

// Cerrar la conexión
mysqli_close($conn);
?>

</body>
</html>
