<?php
error_reporting(E_ALL ^ E_NOTICE);
// Permite solicitudes desde http://localhost:4200
//header("Access-Control-Allow-Origin: http://localhost:4200");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Si la solicitud es de tipo OPTIONS, responde con los encabezados CORS y termina la ejecuciOn
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("HTTP/1.1 200 OK");
    exit;
}

// Directorio donde se encuentran los archivos
$directorioArchivos = dirname(__FILE__) . '/pdfs/'; // Ruta relativa al directorio actual del archivo PHP

// Validar si se ha enviado una peticiOn de descarga
if (!empty($_GET['nombre']) && !empty($_GET['tipo'])) {
    $nombreArchivo = $_GET['nombre'];
    $tipoArchivo = $_GET['tipo'];
    $rutaArchivo = $directorioArchivos . $nombreArchivo;

    // Validar que el archivo exista
    if (file_exists($rutaArchivo)) {
        // Establecer las cabeceras para la descarga
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $nombreArchivo . '"');
        header('Content-Length: ' . filesize($rutaArchivo));

        // Enviar el archivo al cliente
        readfile($rutaArchivo);
        exit;
    }
}

// El archivo no existe
http_response_code(404);
echo 'El archivo solicitado no está disponible para descarga.';
exit;


?>
